// Explore downward for 60 seconds: exploreUntil(bot, new Vec3(0, -1, 0), 60);
async function exploreUntilFind(
    bot,
    blockName,
    maxTime = 60
) {
    const maxDistance = 32;
    function findMatchingBlock() {
        return bot.findBlock({
            matching: block => blockName === block.name,
            maxDistance: maxDistance
        });
    }
    if (typeof maxTime !== "number") {
        throw new Error("maxTime must be a number");
    }
    const test = findMatchingBlock();
    if (test) {
        bot.chat(`[Action Event] exploreUntilFind${blockName}->succeeded`);
        console.log(`[Action Event] exploreUntilFind${blockName}->succeeded`);
        return Promise.resolve(test);
    }
    const direction = getDirectionByBlockAndDepth(blockName, bot.entity.position.y);
    if (direction.x === 0 && direction.y === 0 && direction.z === 0) {
        throw new Error("direction cannot be 0, 0, 0");
    }
    if (
        !(
            (direction.x === 0 || direction.x === 1 || direction.x === -1) &&
            (direction.y === 0 || direction.y === 1 || direction.y === -1) &&
            (direction.z === 0 || direction.z === 1 || direction.z === -1)
        )
    ) {
        throw new Error(
            "direction must be a Vec3 only with value of -1, 0 or 1"
        );
    }
    maxTime = Math.min(maxTime, 1200);
    return new Promise((resolve, reject) => {
        const dx = direction.x;
        const dy = direction.y;
        const dz = direction.z;

        let explorationInterval;
        let maxTimeTimeout;

        const cleanUp = () => {
            clearInterval(explorationInterval);
            clearTimeout(maxTimeTimeout);
            bot.pathfinder.setGoal(null);
        };

        const explore = () => {
            const x =
                bot.entity.position.x +
                Math.floor(Math.random() * 10 + 10) * dx;
            const y =
                bot.entity.position.y +
                Math.floor(Math.random() * 10 + 10) * dy;
            const z =
                bot.entity.position.z +
                Math.floor(Math.random() * 10 + 10) * dz;
            let goal = new GoalNear(x, y, z);
            if (dy === 0) {
                goal = new GoalNearXZ(x, z);
            }
            bot.pathfinder.setGoal(goal);

            try {
                const result = findMatchingBlock();
                if (result) {
                    cleanUp();
                    bot.chat(`[Action Event] exploreUntilFind${blockName}->succeeded`);
                    console.log(`[Action Event] exploreUntilFind${blockName}->succeeded`);
                    resolve(result);
                }
            } catch (err) {
                cleanUp();
                reject(err);
            }
        };

        explorationInterval = setInterval(explore, 2000);

        maxTimeTimeout = setTimeout(() => {
            cleanUp();
            bot.chat(`[Action Event] exploreUntilFind${blockName}->failed`);
            console.log(`[Action Event] exploreUntilFind${blockName}->failed`);
        resolve(null);
        }, maxTime * 1000);
    });
}
